﻿window.voxco = window.voxco || {};

(function (security, $, undefined) {
    //Private variables
    var cache = {};

    //Private functions
    function decodeAndParsePermissions(encodedPermissions) {
        var permissions = null;

        if (encodedPermissions) {
            var hash = encodedPermissions.hashCode().toString();

            if (hash in cache) {
                permissions = cache[hash];
            }
            else {
                try {
                    permissions = JSON.parse(atob(encodedPermissions));
                }
                catch (e) { }

                cache[hash] = permissions;
            }
        }

        return permissions;
    }

    function getPermissions(objectPermissions) {
        if (!objectPermissions)
            objectPermissions = $("#user-permissions").val();

        return decodeAndParsePermissions(objectPermissions);
    }

    //Public functions
    security.has = function (permission, objectPermissions) {
        var permissions = getPermissions(objectPermissions);

        if (permissions)
            return permissions.IsAdministrator === true || permissions.Permissions[permission] == 1;

        return false;
    };

    security.hasFeature = function (feature) {
        var permissions = getPermissions();

        if (permissions)
            return permissions.IsAdministrator === true || permissions.Features[feature] == 1;

        return false;
    };
}(window.voxco.security = window.voxco.security || {}, jQuery));